
window.analyzify.initRebuy = () => {

  /*
  Reference:
  https://developers.rebuyengine.com/reference/cart-event-listeners
  */

  analyzify.log('rebuy init', 'an_rebuy', 'initRebuy');
  const props = window.analyzify.properties;

  document.addEventListener("rebuy:smartcart.line-item-increase", (event) => {
    analyzify.log('rebuy:smartcart.line-item-increase', 'an_rebuy', 'lineItemIncrease');
    let item = event.detail.item.product;
    // item.id = item?.id || item?.variant_id;
    // item.title = item?.title || item?.variant_title;
    // item.price = analyzify.formatPrice(item.price);
    // item.item_quantity = 1;
    // item.brand = item?.vendor;
    // item.category = item?.type;
    // item.variants = [{id: item.id || item?.variant_id, title: item?.title || item?.variant_title }];
    // item.item_variant = item.title;
    // item.affiliation = 'rebuy';
    // item.quantity = 1;
    
    if (props.GADS.status || props.GA4.status) {
      analyzify.gaAddToCart(item);
    }
    if (props.X.status) {
      analyzify.xAddtoCart(item);
    }
    if (props.FACEBOOK.status) {
      analyzify.fbAddToCart(item);
    }
    if (props.BING.status) {
      analyzify.bingAddtoCart(item);
    }
    if (props.PINTEREST.status) {
      analyzify.pinterestAddtoCart(item);
    }
    if (props.KLAVIYO.status) {
      analyzify.klaviyoAddToCart(item);
    }
    if (props.GTM.status) {
      // actual check was {% if app.metafields.analyzify.gtm_dataLayer %}
      analyzify.gtmAddToCart(item);
    }
    if (props.TIKTOK.status) {
      analyzify.ttAddToCart(item);
    }
  });

  // document.addEventListener("rebuy:cart.add", (event) => {
  //   analyzify.log('rebuy:cart.add', 'an_rebuy', 'cartAdd');

  //   let item = event.detail.item;

  //   if (props.GADS.status || props.GA4.status) {
  //     analyzify.gaAddToCart(item);
  //   }
  //   if (props.X.status) {
  //     analyzify.xAddtoCart(item);
  //   }
  //   if (props.FACEBOOK.status) {
  //     analyzify.fbAddToCart(item);
  //   }
  //   if (props.BING.status) {
  //     analyzify.bingAddtoCart(item);
  //   }
  //   if (props.PINTEREST.status) {
  //     analyzify.pinterestAddtoCart(item);
  //   }
  //   if (props.KLAVIYO.status) {
  //     analyzify.klaviyoAddToCart(item);
  //   }
  //   if (props.GTM.status) {
  //     // actual check was {% if app.metafields.analyzify.gtm_dataLayer %}
  //     analyzify.gtmAddToCart(item);
  //   }
  //   if (props.TIKTOK.status) {
  //     analyzify.ttAddToCart(item);
  //   }
  // });

  document.addEventListener("rebuy:smartcart.line-item-decrease", (event) => {
      analyzify.log('rebuy:smartcart.line-item-decrease', 'an_rebuy', 'lineItemDecrease');

      let item = event.detail.item.product;

      if (props.GADS.status || props.GA4.status) {
        analyzify.gaRebuyRfc(item);
      }
      if (props.GTM.status) {
        analyzify.gtmRemoveFromCart(item);
      }
  });

  document.addEventListener("rebuy:smartcart.line-item-removed", (event) => {
      analyzify.log('rebuy:smartcart.line-item-removed', 'an_rebuy', 'lineItemRemoved');

      let item = event.detail.item.product;
      
      if (props.GADS.status || props.GA4.status) {
        analyzify.gaRebuyRfc(item);
      }
      if (props.GTM.status) {
        analyzify.gtmRemoveFromCart(item);
      }
    },
  );

};
